//--------------------------------------------------------------------------------------
// data types used across all shaders
//--------------------------------------------------------------------------------------

// samplers
Texture2D txDiffuse : register( t0 );
SamplerState samLinear : register( s0 );

//--------------------------------------------------------------------------------------
// constant buffers
//--------------------------------------------------------------------------------------
cbuffer cbNeverChanges : register( b0 )
{
    float FOV;
    float ScreenRatio;
};


cbuffer cbChangesEveryFrame : register( b1 )
{
    matrix  World;
	matrix  View;
	matrix  Projection;
    float   SequenceRatio;
    float   SequenceDuration;
    
    float   CameraRotX; // in radians
    float   CameraRotY; // in radians
    float4  CameraPos;
    float4  CameraTarget;
};

cbuffer cbLedPorperties : register( b2 )
{
    float4 Intensity[1024];
};

//--------------------------------------------------------------------------------------
// Vertex Shader input
//--------------------------------------------------------------------------------------
struct PS_INPUT
{
    float4 Pos      : SV_POSITION;
    float2 Tex      : TEXCOORD0;
    float3 Nor      : NORMAL0;
    float3 LightDir : TEXCOORD2;
    float3 HalfVect : TEXCOORD3;
};

// constants
const static float4 colorFlash = float4(0.0f,0.0f,0.0f,1.0f);

//const static float leds[16*16*16] = 0.;